#include <iostream>
#include <vector>
#include <bits/stdc++.h>
using namespace std;

void swap(vector<int>& arr, int a, int b);
void dodaj_put (vector<int> adj[], int src, int dest);
bool BFS(vector<int> adj[], int src, int dest, int v, int pred[], int dist[]);
int najkraciPut(vector<int> adj[], int src, int dest, int v);

int main() {
    int N;
    cin>>N;
    vector<int> naselja;
    for(int i=0;i<N;i++) {
        int a;
        cin >> a;
        naselja.push_back(a);
    }
    vector<int> adj[N];
    for(int i=0;i<N-1;i++) {
        int a, b;
        cin >> a >> b;
        dodaj_put(adj, a-1, b-1);
    }
    int Q;
    cin >> Q;
    vector<vector <int>> matrica_desavanja;

    for(int i=0;i<Q;i++) {
        int broj_desavanja;
        cin>>broj_desavanja;
        if(broj_desavanja == 1) {
            int a, b;
            cin >> a >> b;
            matrica_desavanja.push_back({broj_desavanja, a, b});
        } else {
            int l, r, x;
            cin >> l >> r >> x;
            matrica_desavanja.push_back({broj_desavanja, l, r, x});
        }
    }
    for(int i=0;i<matrica_desavanja.size();i++) {
        if(matrica_desavanja[i][0] == 1) {
            swap(naselja, matrica_desavanja[i][1]-1, matrica_desavanja[i][2]-1);
        } else if(matrica_desavanja[i][0] == 2) {
            int src = matrica_desavanja[i][3]-1;
            int max = 0;
            for(int j=matrica_desavanja[i][1]-1; j<=matrica_desavanja[i][2]-1; j++) {
                int dist = najkraciPut(adj, src, naselja[j]-1, N);
                if(max < dist)
                    max = dist;
            }
            cout << max << endl;
        }
    }
}

void swap(vector<int>& arr, int a, int b){
    int tmp = arr[a];
    arr[a] = arr[b];
    arr[b] = tmp;
}

void dodaj_put(vector<int> adj[], int src, int dest){
    adj[src].push_back(dest);
    adj[dest].push_back(src);
}

bool BFS(vector<int> adj[], int src, int dest, int v, int pred[], int dist[]){
    list<int> queue;
    bool visited[v];
    for (int i = 0; i < v; i++) {
        visited[i] = false;
        dist[i] = INT_MAX;
        pred[i] = -1;
    }
    visited[src] = true;
    dist[src] = 0;
    queue.push_back(src);
    while (!queue.empty()) {
        int u = queue.front();
        queue.pop_front();
        for (int i = 0; i < adj[u].size(); i++) {
            if (visited[adj[u][i]] == false) {
                visited[adj[u][i]] = true;
                dist[adj[u][i]] = dist[u] + 1;
                pred[adj[u][i]] = u;
                queue.push_back(adj[u][i]);
                if (adj[u][i] == dest)
                    return true;
            }
        }
    }
    return false;
}

int najkraciPut(vector<int> adj[], int src, int dest, int v){
    int pred[v], dist[v];
    if (BFS(adj, src, dest, v, pred, dist) == false) {
        return -1;
    }
    return dist[dest];
}